<?php defined("SYSPATH") or die("No direct script access.");
/**
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2009 Bharat Mediratta
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
class Admin_Album_Carousel_Controller extends Admin_Controller {
  public function index() {
    print $this->_get_view();
  }

  public function handler() {
    access::verify_csrf();

    $form = $this->_get_form();
    if ($form->validate()) {
      module::set_var(
        "album_carousel", "thumbsize", $form->carousel->thumbsize->value);
      module::set_var(
        "album_carousel", "mouse", $form->carousel->mouse->value);
      module::set_var(
        "album_carousel", "width", $form->carousel->width->value);
      module::set_var(
        "album_carousel", "height", $form->carousel->height->value);		
      module::set_var(
        "album_carousel", "onphoto", $form->carousel->onphoto->value);
      module::set_var(
        "album_carousel", "onalbum", $form->carousel->onalbum->value);
        
        
      message::success(t("Your settings have been saved."));
      url::redirect("admin/album_carousel");
	}
    print $this->_get_view($form);
  }

  private function _get_view($form=null) {
    $v = new Admin_View("admin.html");
    $v->content = new View("admin_album_carousel.html");
    $v->content->form = empty($form) ? $this->_get_form() : $form;
    return $v;
  }

  private function _get_form() {
    $form = new Forge("admin/album_carousel/handler", "", "post", array("id" => "g-admin-form"));
    
    $group = $form->group("carousel")->label(t("General carousel settings"));
	$group->input("thumbsize")->label(t('Enter the size of the thumbs. (pixels)'))
		->value(module::get_var("album_carousel", "thumbsize", "50"))
		->rules("valid_numeric|length[1,3]");
    $group->checkbox("mouse")->label(t('Enable the mouseover to scroll carousel.'))
		->checked(module::get_var("album_carousel", "mouse", "0"));
	$group->input("width")->label(t('Enter the width of the carousel. (pixels)'))
		->value(module::get_var("album_carousel", "width", "900"))
		->rules("valid_numeric|length[1,3]");
	$group->input("height")->label(t('Enter the height of the carousel. (pixels)'))
		->value(module::get_var("album_carousel", "height", "100"))
		->rules("valid_numeric|length[1,3]");		
	$group->checkbox("onalbum")->label(t("Show on album pages"))
		->checked(module::get_var("album_carousel", "onalbum", "0"));
	$group->checkbox("onphoto")->label(t("Show on photo pages"))
		->checked(module::get_var("album_carousel", "onphoto", "0")); 
   
    
	$form->submit("submit")->value(t("Save"));
    return $form;
  }
}