<?php defined("SYSPATH") or die("No direct script access.");
/**
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2014 Bharat Mediratta
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */

class Admin_Comment_Spam_Finder_Controller extends Admin_Controller {
  public function index() {
    print $this->_get_view();
  }
  private function _get_view($form=null) {
    $v = new Admin_View("admin.html");
    $v->content = new View("admin_comment_spam_finder.html");
    $v->content->comments = ORM::factory("comment")
      ->order_by("created", "DESC")
      ->order_by("id", "DESC")
      ->find_all();
    return $v;
  }
  public function delete_checked_comments() {
    access::verify_csrf();
    $comment_id = $_POST['comment_id']; 
    if(empty($comment_id)) {
    message::success(t("No comments deleted."));
    url::redirect("admin/comment_spam_finder");
    }
    else {
    $count = count($comment_id);
    foreach($comment_id as $id) {
      db::build()
        ->delete("comments")
        ->where("id", "=", $id)
        ->execute();
      }
    message::success(t("Deleted %count comments.", array("count" => $count)));
    url::redirect("admin/comment_spam_finder");
    }
  }
}

