<?php defined("SYSPATH") or die("No direct script access.") ?>
<div id="g-comment-spam-admin">
  <form action="<?= url::site("admin/comment_spam_finder/delete_checked_comments/") ?>" method="post" id="g-delete-comments" name="delete_comments">
  <?= access::csrf_form_field() ?>
  <table id="table">
    <thead>
    <tr>
    <td width="90px"><?= t("Thumb") ?></td>
    <td width="90px"><?= t("Author") ?></td>
    <td width="90px"><?= t("Date") ?></td>
    <td><?= t("Comment") ?></td>
    <td width="190px">
      <input type="submit" class="delete ui-state-default ui-corner-all" value="<?= t("Delete checked") ?>" id="g-del-submit" disabled />
      <br clear="all">
      <input type="button" class="check ui-state-default ui-corner-all" value="<?= t("Check filtered results") ?>" />

    </td>
    </tr>
    </thead>
    <tbody>
    <? foreach ($comments as $comment): ?>
    <tr id="g-comment-<?= $comment->id ?>" class="<?= text::alternate("g-odd", "g-even") ?>">
      <td><? $item = $comment->item() ?>
        <div class="g-item g-photo">
            <a href="<?= $item->url() ?>">
              <? if ($item->has_thumb()): ?>
              <img src="<?= $item->thumb_url() ?>"
                 alt="<?= html::purify($item->title)->for_html_attr() ?>"
                 <?= photo::img_dimensions($item->thumb_width, $item->thumb_height, 75) ?>
              />
              <? else: ?>
              <?= t("No thumbnail") ?>
              <? endif ?>
            </a>
        </div>
      </td>
      <td><?= html::clean($comment->author_name()) ?>
          <a href="mailto:<?= html::clean_attribute($comment->author_email()) ?>"
             title="<?= html::clean_attribute($comment->author_email()) ?>">
            email
          </a>
      </td>
      <td>
        <p><?= gallery::date($comment->created) ?></p>
      </td>
      <td>
        <?= nl2br(html::purify($comment->text)) ?>
      </td>
      <td>
        <input type="checkbox" id="comment<?=$comment->id?>" class="css-checkbox" name="comment_id[]" value="<?=$comment->id?>">
        <label for="comment<?=$comment->id?>" class="css-label"><span><?=$comment->id?></span></label>
      </td>
    </tr>
    <? endforeach ?>
  </tbody>
  </table>
  </form>
</div>
<script>
$('.check:button').click(function () {
    var checked = !$(this).data('checked');
    $('.delete:submit').prop('disabled', !checked);
    $(".delete:submit").css({ opacity: 1 });
    $(this).data('checked', checked);
    if (checked == true) {
        $(this).val('<?= t("Uncheck filtered results") ?>');
        $(".delete:submit").css({ opacity: 1 });
        checkAll();
    } else if (checked == false) {
        $(this).val('<?= t("Check filtered results") ?>');
        $(".delete:submit").css({ opacity: 0.5 });
        uncheckAll();
    }
});
$(function() {
  $( "input[name^=comment_id]" ).click(function(){
    if($(this).attr('checked') == false){
         $('#g-del-submit').attr("disabled","disabled");
         $("#g-del-submit").css({ opacity: 0.5 });
    }
    else{
        $('#g-del-submit').removeAttr('disabled');
        $("#g-del-submit").css({ opacity: 1 });
    }
  });
});
$('.delete:submit').click(function () {
    var array = $('input:checkbox:checked').map(function () {
        return this.value
    }).get();
})
</script>