<?php defined("SYSPATH") or die("No direct script access.");
/**
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2012 Bharat Mediratta
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
class carousel_block_Core {
  static function get_site_list() {
    return array(
		"carousel_recent" 		=> t("Recent items carousel"),
		"carousel_popular" 		=> t("Popular items carousel"),
		"carousel_random" 		=> t("Random items carousel"),
		"carousel_random_album" => t("Random album carousel"),
		"carousel_recent_in" 	=> t("Recent items in album carousel"),
		"carousel_popular_in" 	=> t("Popular items in album carousel"));
	}

  static function get($block_id, $theme) {
    $block	= "";
    switch ($block_id) {
    case "carousel_recent":
      if (module::get_var("carousel", "onalbum2") && $theme->page_type == "collection"  || 
		  module::get_var("carousel", "onphoto2") && $theme->page_type == "item") {
        $block = new Block();
        $block->css_id 				= "g-carousel-rec";
		$block->title 				= module::get_var("carousel", "title2", "Recent items");
	    $block->content 			= new View("carousel_recent.html");
		$block->content->circular 	= module::get_var("carousel", "circular", "false");
		$block->content->autoscroll = module::get_var("carousel", "autoscroll", "false");
		$block->content->auto 		= module::get_var("carousel", "autostart", "800");
		$block->content->speed 		= module::get_var("carousel", "speed", "1000");
		$block->content->quantity	= module::get_var("carousel", "quantity2", "1");
		$block->content->visible	= module::get_var("carousel", "visible2", "1");
		$block->content->thumbsize	= module::get_var("carousel", "thumbsize2");
		$block->content->photos		= ORM::factory("item")->viewable()
										->where("type", "!=", "album")
										->order_by("created", "DESC")
										->find_all(module::get_var("carousel", "quantity2", "1"));
	  }
      break;
    case "carousel_popular":
      if (module::get_var("carousel", "onalbum3") && $theme->page_type == "collection"  ||
	  	  module::get_var("carousel", "onphoto3") && $theme->page_type == "item") {
        $block = new Block();
        $block->css_id 				= "g-carousel-pop";
        $block->title 				= module::get_var("carousel", "title3", "Popular items");
	    $block->content 			= new View("carousel_popular.html");
		$block->content->circular 	= module::get_var("carousel", "circular", "false");
		$block->content->autoscroll = module::get_var("carousel", "autoscroll", "false");
		$block->content->auto 		= module::get_var("carousel", "autostart", "800");
		$block->content->speed 		= module::get_var("carousel", "speed", "1000");
		$block->content->quantity	= module::get_var("carousel", "quantity3", "1");
		$block->content->visible	= module::get_var("carousel", "visible3", "1");
		$block->content->thumbsize	= module::get_var("carousel", "thumbsize3");
		$block->content->photos		= ORM::factory("item")->viewable()
										->where("type", "!=", "album")
										->order_by("view_count", "DESC")
										->find_all(module::get_var("carousel", "quantity3", "1"));
	}
      break;
    case "carousel_random":
      if (module::get_var("carousel", "onalbum") && $theme->page_type == "collection"  || 
		  module::get_var("carousel", "onphoto") && $theme->page_type == "item") {
        $block = new Block();
        $block->css_id 				= "g-carousel-ran";
        $block->title 				= module::get_var("carousel", "title", "Random items");
	    $block->content 			= new View("carousel_random.html");
		$block->content->circular 	= module::get_var("carousel", "circular", "false");
		$block->content->autoscroll = module::get_var("carousel", "autoscroll", "false");
		$block->content->auto 		= module::get_var("carousel", "autostart", "800");
		$block->content->speed 		= module::get_var("carousel", "speed", "1000");
		$block->content->quantity	= module::get_var("carousel", "quantity", "1");
		$block->content->visible	= module::get_var("carousel", "visible", "1");
		$block->content->thumbsize	= module::get_var("carousel", "thumbsize");
		$block->content->photos		= ORM::factory("item")->viewable()
										->where("rand_key", "<", ((float)mt_rand()) / (float)mt_getrandmax())
										->merge_where(NULL)
										->order_by("rand_key", "DESC")
										->find_all(module::get_var("carousel", "quantity", "1"));
	}
      break;
    case "carousel_random_album":
      if (module::get_var("carousel", "onalbum4") && $theme->page_type == "collection"  || 
		  module::get_var("carousel", "onphoto4") && $theme->page_type == "item") {
        $block = new Block();
        $block->css_id 				= "g-carousel-ran-al";
        $block->title 				= module::get_var("carousel", "title4", "Random album");
	    $block->content 			= new View("carousel_random_album.html");
		$block->content->circular 	= module::get_var("carousel", "circular", "false");
		$block->content->autoscroll = module::get_var("carousel", "autoscroll", "false");
		$block->content->auto 		= module::get_var("carousel", "autostart", "800");
		$block->content->speed 		= module::get_var("carousel", "speed", "1000");
		$block->content->quantity	= module::get_var("carousel", "quantity4", "1");
		$block->content->visible	= module::get_var("carousel", "visible4", "1");
		$block->content->thumbsize	= module::get_var("carousel", "thumbsize4");
		$block->content->photos		= ORM::factory("item")->viewable()
										->where("rand_key", "<", ((float)mt_rand()) / (float)mt_getrandmax())
										->where("type", "=", "album")
										->order_by("rand_key", "DESC")
										->find_all(module::get_var("carousel", "quantity", "1"));
	  }
      break;
    case "carousel_recent_in":
		// if the item is a item get the parent else use the current album
		if ($theme->item->is_album()) {
			$this_id = $theme->item->id;
		} else {
			$this_id = $theme->item->parent_id;
		}
		// different queries if we want to see the items inside the sub-albums as well
		// reset the $photos variable so we can see if if it empty later
		$photos = NULL;
		if (module::get_var("carousel", "onalbum5sub") == true) {
		  $photos = ORM::factory("item", $this_id)->viewable()
								->order_by("created", "DESC")
								->descendants(module::get_var("carousel", "quantity5", "1"), NULL, array(array("type", "=", "photo")));
		} else {
	     $photos = ORM::factory("item")->viewable()
								->where("type", "!=", "album")
								->where("parent_id", "=", $this_id)
								->order_by("created", "DESC")
								->find_all(module::get_var("carousel", "quantity5", "1"));
		}
	  // only show the block if there is items to show	
      if (count($photos) > 1) {
      if (module::get_var("carousel", "onalbum5") && $theme->page_type == "collection"  || 
		  module::get_var("carousel", "onphoto5") && $theme->page_type == "item") {
        $block = new Block();
        $block->css_id 				= "g-carousel-rec-in";
        $block->title 				= module::get_var("carousel", "title5", "Recent items in this album");
	    $block->content 			= new View("carousel_recent_in.html");
		$block->content->circular 	= module::get_var("carousel", "circular", "false");
		$block->content->autoscroll = module::get_var("carousel", "autoscroll", "false");
		$block->content->auto 		= module::get_var("carousel", "autostart", "800");
		$block->content->speed 		= module::get_var("carousel", "speed", "1000");
		$block->content->quantity	= module::get_var("carousel", "quantity5", "1");
		$block->content->visible	= module::get_var("carousel", "visible5", "1");
		$block->content->thumbsize	= module::get_var("carousel", "thumbsize5");
		$block->content->photos		= $photos;
	  }
	  }
      break;
    case "carousel_popular_in":
		// if the item is a item get the parent else use the current album
		// reset the $photos variable so we can see if if it empty later
		$photos = NULL;
		if ($theme->item->is_album()) {
			$this_id = $theme->item->id;
		} else {
			$this_id = $theme->item->parent_id;
		}
		// different queries if we want to see the items inside the su-albums as well
		if (module::get_var("carousel", "onalbum6sub") == true) {
		  $photos = ORM::factory("item", $this_id)->viewable()
								->order_by("view_count", "DESC")
								->descendants(module::get_var("carousel", "quantity6", "1"), NULL, array(array("type", "=", "photo")));
		} else {
	     $photos = ORM::factory("item")->viewable()
								->where("type", "!=", "album")
								->where("parent_id", "=", $this_id)
								->order_by("view_count", "DESC")
								->find_all(module::get_var("carousel", "quantity6", "1"));
		}
	  // only show the block if there is items to show 
      if (count($photos) > 1) {
	  if (module::get_var("carousel", "onalbum6") && $theme->page_type == "collection"  || 
		  module::get_var("carousel", "onphoto6") && $theme->page_type == "item") {
        $block = new Block();
        $block->css_id 				= "g-carousel-pop-in";
        $block->title 				= module::get_var("carousel", "title6", "Random items");
	    $block->content 			= new View("carousel_popular_in.html");
		$block->content->circular 	= module::get_var("carousel", "circular", "false");
		$block->content->autoscroll = module::get_var("carousel", "autoscroll", "false");
		$block->content->auto 		= module::get_var("carousel", "autostart", "800");
		$block->content->speed 		= module::get_var("carousel", "speed", "1000");
		$block->content->quantity	= module::get_var("carousel", "quantity6", "1");
		$block->content->visible	= module::get_var("carousel", "visible6", "1");
		$block->content->thumbsize	= module::get_var("carousel", "thumbsize6");
		$block->content->photos		= $photos;
	  }
	  }
      break;
    }
    return $block;
  }
}