<?php defined("SYSPATH") or die("No direct script access.");
/**
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2009 Bharat Mediratta
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
class Admin_Remove_actions_Controller extends Admin_Controller {
  public function index() {
    print $this->_get_view();
  }

  public function handler() {
    access::verify_csrf();

    $form = $this->_get_form();
    if ($form->validate()) {
      module::set_var(
        "remove_actions", "album", $form->remove_actions->album->value);
      module::set_var(
        "remove_actions", "addphotos", $form->remove_actions->addphotos->value);
      module::set_var(
        "remove_actions", "addmenu", $form->remove_actions->addmenu->value);
      module::set_var(
        "remove_actions", "permissions", $form->remove_actions->permissions->value);
      module::set_var(
        "remove_actions", "organise", $form->remove_actions->organise->value);
      module::set_var(
        "remove_actions", "editalbum", $form->remove_actions->editalbum->value);
      module::set_var(
        "remove_actions", "editphoto", $form->remove_actions->editphoto->value);
      module::set_var(
        "remove_actions", "cwphoto", $form->remove_actions->cwphoto->value);
      module::set_var(
        "remove_actions", "ccwphoto", $form->remove_actions->ccwphoto->value);	
      module::set_var(
        "remove_actions", "deletephoto", $form->remove_actions->deletephoto->value);
      module::set_var(
        "remove_actions", "deletealbum", $form->remove_actions->deletealbum->value);
      module::set_var(
        "remove_actions", "movetoalbum", $form->remove_actions->movetoalbum->value);
      module::set_var(
        "remove_actions", "changepass", $form->remove_actions->changepass->value);
      module::set_var(
        "remove_actions", "changeemail", $form->remove_actions->changeemail->value);
      module::set_var(
        "remove_actions", "edituser", $form->remove_actions->edituser->value);
      module::set_var(
        "remove_actions", "profilelink", $form->remove_actions->profilelink->value);
		
      message::success(t("Your settings have been saved."));
      url::redirect("admin/remove_actions");
    }

    print $this->_get_view($form);
  }

  private function _get_view($form=null) {
    $v = new Admin_View("admin.html");
    $v->content = new View("admin_remove_actions.html");
    $v->content->form = empty($form) ? $this->_get_form() : $form;
    return $v;
  }

  private function _get_form() {
    $form = new Forge("admin/remove_actions/handler", "", "post", array("id" => "g-admin-form"));
    $group = $form->group("remove_actions")->label(t('Remove actions'));
    
	$group->checkbox("album")->label(t('Remove the "Add an album" action.'))
						  ->checked(module::get_var("remove_actions", "album"));
	$group->checkbox("addphotos")->label(t('Remove the "Add photos" action.'))
						  ->checked(module::get_var("remove_actions", "addphotos"));
	$group->checkbox("addmenu")->label(t('Remove the "Add" action from the menu.'))
						  ->checked(module::get_var("remove_actions", "addmenu"));
	$group->checkbox("permissions")->label(t('Remove the "Edit permissons" action.'))
						  ->checked(module::get_var("remove_actions", "permissions"));
	$group->checkbox("editalbum")->label(t('Remove the "Edit album" action.'))
						  ->checked(module::get_var("remove_actions", "editalbum"));
	$group->checkbox("organise")->label(t('Remove the "Organise album" action.'))
						  ->checked(module::get_var("remove_actions", "organise"));
	$group->checkbox("editphoto")->label(t('Remove the "Edit photo" action.'))
						  ->checked(module::get_var("remove_actions", "editphoto"));
	$group->checkbox("cwphoto")->label(t('Remove the "Rotate photo 90° clockwise" action.'))
						  ->checked(module::get_var("remove_actions", "cwphoto"));
	$group->checkbox("ccwphoto")->label(t('Remove the "Rotate photo 90° counter clockwise" action.'))
						  ->checked(module::get_var("remove_actions", "ccwphoto"));
	$group->checkbox("ccwphoto")->label(t('Remove the "Choose as the album cover" action.'))
						  ->checked(module::get_var("remove_actions", "cover"));
	$group->checkbox("deletephoto")->label(t('Remove the "Delete photo" action.'))
						  ->checked(module::get_var("remove_actions", "deletephoto"));
	$group->checkbox("deletealbum")->label(t('Remove the "Delete album" action.'))
						  ->checked(module::get_var("remove_actions", "deletealbum"));
	$group->checkbox("movetoalbum")->label(t('Remove the "Move to another album" action.'))
						  ->checked(module::get_var("remove_actions", "movetoalbum"));
	$group->checkbox("changepass")->label(t('Remove the "Change password" action.'))
						  ->checked(module::get_var("remove_actions", "changepass"));
	$group->checkbox("changeemail")->label(t('Remove the "Change email" action.'))
						  ->checked(module::get_var("remove_actions", "changeemail"));
	$group->checkbox("edituser")->label(t('Remove the "edit" action on the user profile page.'))
						  ->checked(module::get_var("remove_actions", "edituser"));
	$group->checkbox("profilelink")->label(t('Remove the link to the user profile page: Logged in as "user".'))
						  ->checked(module::get_var("remove_actions", "profilelink"));
						  
    $group->submit("submit")->value(t("Save"));

    return $form;
  }
}